% -------------------------------------------------------------------
% Este script hace la figura en la que se resuelve la ecuacin para
% la descomposicin de una especie radiactiva usando el mtodo de Euler.
% Este script requiere que en el espacio de trabajo exista la
% funcin feuler.
% dy/dx = f(x,y;k) = - k*y:
% -------------------------------------------------------------------

k=1;
g = @(t,y) -k*y;    % definicin de funcin annima
y0=100;
t0=0;
tf=5;
Nh=10;
[t,y]=feuler(g,t0,tf,y0,Nh);  % llamada a la rutina del mtodo de Euler


tp=0:0.1:5;
yp=y0*exp(-k*tp);
plot(tp,yp,t,y,'o','MarkerEdgeColor','r');
xlabel('t');
ylabel('N');
title('Mtodo de Euler');
legend('Sol. exacta','Sol. numrica');
text(2,70,'k=1, Nh=10');
